<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Models\transactions;
use App\Models\TransactionCr;
use App\Models\TransactionDr;
use App\Models\TransactionProductDetails;
use App\Models\AccBill;
use App\Models\AccBillDetails;
use App\Models\Vendor;
use App\Models\Product;
use App\Models\AccInvoice;
use App\Models\AccInvoiceDetails;
use App\Models\Customer;
use App\Models\AccInvoicePayment;
use App\Models\SalesQuotationItem;
use App\Models\SalesQuotation;
use App\Models\AccChartOfAccountName;
use App\Models\AccChartOfAccountRootType;

use App\Helper;
use Validator;
use Illuminate\Support\Arr;
use DB;
// use Illuminate\Support\stdClass;

class ReportController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
      return view('Reports.Reports');      
        return view('demo.Reports');
    }

    public function summary(transactions $transactions)
    {
      return view('Reports.Reports');      

      // $dataCr = TransactionCr::groupBy('account_id')->selectRaw('sum(amount) as amount, account_id')->get();
      // $dataDr = TransactionDr::groupBy('account_id')->selectRaw('sum(amount) as amount, account_id')->get();
      
      // return view('Reports.summery',compact('dataCr','dataDr'));      
    }

    public function AccRunReprot(AccChartOfAccountName $AccChartOfAccountName,Request $request,$accid=0)
    {
      // return $request->acc_id;
      if(intval(@$request->acc_id)>0) $accid = intval($request->acc_id);
      $datas = []; $date1= date('Y-m-d'); $info = [];
      if($request->date1) $date1 = $request->date1;
      if($request->date2) $date2 = $request->date2; if (!isset($date2) && isset($date1)) $date2 = $date1;
      if ($accid>0) {
        $sense = 0;
        $AccChartOfAccountName = AccChartOfAccountName::findOrFail($accid);
        $sense = $AccChartOfAccountName->sense;
        $account_opening_balance = $AccChartOfAccountName->account_opening_balance;
        $account_name = $AccChartOfAccountName->account_name;
      // for opening balance of account
      $total_dr =TransactionDr:: select(DB::raw("SUM(amount) as total"))
        ->when($date1,function ($query) use ($date1) {
            $query->whereHas('transactions', function($query) use ($date1){
              $query->where('status','>', 0)->where('transaction_date','<',$date1);
            });
        })
        ->where('account_id','=',$accid)->get();
   
      $total_cr =TransactionCr:: select(DB::raw("SUM(amount) as total"))
        ->when($date1,function ($query) use ($date1) {
            $query->whereHas('transactions', function($query) use ($date1){
              $query->where('status','>', 0)->where('transaction_date','<',$date1);
            });
        })
        ->where('account_id','=',$accid)->get();

      if ($sense==1) {
        $openingTotal = $total_dr[0]->total - $total_cr[0]->total;
      }elseif($sense==2){
        $openingTotal = $total_cr[0]->total - $total_dr[0]->total;
      }
     $info['openingTotal'] = $openingTotal+$account_opening_balance;
     $info['total_dr'] = (int)$total_dr[0]->total;
     $info['total_cr'] = (int)$total_cr[0]->total;
     $info['date1'] = $date1;
     $info['date2'] = $date2;
     $info['sense'] = $sense;
     $info['account_name'] = $account_name;
     $info['account_opening_balance'] = $account_opening_balance;
     
     // end opening balace area

      $accDr = TransactionDr::select(["*",DB::raw("1 as type")])
      ->when($date1,function ($query) use ($date1,$date2) {
            $query->whereHas('transactions', function($query) use ($date1,$date2){
              $query->where('status','>', 0)->whereBetween('transaction_date',[$date1,$date2]);
            });
        })
      ->where('account_id','=',$accid)->get();

      $accCr = TransactionCr::select(["*",DB::raw("2 as type")])
      ->when($date1,function ($query) use ($date1,$date2) {
            $query->whereHas('transactions', function($query) use ($date1,$date2){
              $query->where('status','>', 0)->whereBetween('transaction_date',[$date1,$date2]);
            });
        })
      ->where('account_id','=',$accid)->get(); 
      foreach ($accDr as $key => $value) {
         $datas[] = $value;
      }
      foreach ($accCr as $key => $value) {
         $datas[] = $value;
      }
      $datas = Arr::sort($datas,'trans_id');
      // $datas = Arr::sort($datas,'transaction_date');
      }
      return view('Reports.ChartOfAccount.AccRunReprot',compact('datas','info'));      
    }


    public function AccBalanceSheet(AccChartOfAccountName $AccChartOfAccountName,Request $request,$company_id=0,$branch=0)
    {
      // return $request->acc_id;
      if(intval(@$request->company_id)>0) $company_id = intval($request->company_id);
      $datas = []; $info = []; $date1= date('Y-m-d'); 
         $info['date1'] = $date1;
      if ($company_id>0) {
         $info['date1'] = $date1;
      }
      $accRoots = AccChartOfAccountRootType::where('rootID',1)->get();
      $accRoots2 = AccChartOfAccountRootType::whereIn('rootID',[2,3,4,5])->get();
      // $accRoots = AccChartOfAccountRootType::get();
      return view('Reports.ChartOfAccount.AccBalanceSheet',compact('datas','info','accRoots'));      
    }


    public function AccProfitLoss(AccChartOfAccountName $AccChartOfAccountName,Request $request,$company_id=0,$branch=0)
    {
      // return $request->acc_id;
      if(intval(@$request->company_id)>0) $company_id = intval($request->company_id);
      $datas = []; $info = []; $date1= date('Y-m-d'); 
         $info['date1'] = $date1;
      if ($company_id>0) {
         $info['date1'] = $date1;
      }
      $accRoots = AccChartOfAccountRootType::where('rootID',1)->get();
      $accRoots2 = AccChartOfAccountRootType::whereIn('rootID',[2,3,4,5])->get();
      // $accRoots = AccChartOfAccountRootType::get();
      return view('Reports.ChartOfAccount.AccProfitLoss',compact('datas','info','accRoots'));      
    }
    public function TrialBalance(AccChartOfAccountName $AccChartOfAccountName,Request $request,$company_id=0,$branch=0)
    {
    
      if(intval(@$request->company_id)>0) $company_id = intval($request->company_id);
      $datas = AccChartOfAccountName::get();
      return view('Reports.ChartOfAccount.TrialBalance',compact('datas'));      
    }
    
    


}
