<?php

namespace App\Http\Controllers\Members;
use App\Http\Controllers\Controller;

use App\Models\Members;

use Illuminate\Http\Request;


use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\Storage;

use Validator;


class MembersController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        // return $request->all();
        $name= $request->name;
        $contact= $request->contact;
        $ssc= $request->ssc;
        $hsc= $request->hsc;
        $status= $request->status;
        $perPage = $request->has('limit')?$request->limit:100;

        $datas =  Members::oldest('id')
        ->when($name,function ($query) use ($name) {
            return $query->where('name','like','%'.$name.'%')->orWhere('name_bangla','like','%'.$name.'%');
        })
        ->when($contact,function ($query) use ($contact) {
            return $query->where('mobile',$contact)->orWhere('email',$contact);
        })
        ->when($ssc,function ($query) use ($ssc) {
            return $query->where('ssc_batch',$ssc );
        })
        ->when($hsc,function ($query) use ($hsc) {
            return $query->where('hsc_batch',$hsc );
        })
        ->when($status,function ($query) use ($status) {
            return $query->where('status',$status );
        })
        ->paginate($perPage);;
      return view('members.IndexMember',compact('datas'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
// return $request->all(); 
      $validator = Validator::make($request->all(), [
      'name' => 'required|min:1',
      'mobile' => 'required|unique:members',
    //   'email' => 'required|min:1',
    //   'ssc_batch' => 'required|min:1',
    //   'hsc_batch' => 'required|min:1',
      ]);
      if ($validator->fails()) {
      return back()->withErrors($validator)->withInput();
      }

      $data = new Members;
      $data->fill($request->all());
      $data->created_by = $request->user()->id;
      $data->updated_by = $request->user()->id;
      $data->member_date = date('Y-m-d');
      $data->reg_ip = \Request::ip();
      if($request->by>0){
        $data->birth_date = $request->by.'-'.$request->bm.'-'.$request->bd;
      }else  unset($data->birth_date);// $data->birth_date = '0000-00-00';
    //  return  $data;
/*
      if($request->file('photo_path')){
        $file = $request->file('photo_path');
        $filesize = $file->getSize();
        //Move Uploaded File
        $request->filename=$file;
        $nextFileName = 'cus_p_'.time().'i'.$request->user()->id;
        $destinationPath = '/uploads/Members/Photo/'.date('Y').'/'.date('m').'';
        $data->photo_path = $destinationPath.'/'.$uploadres['imagename'];
        $uploadres =   $this->fileUpload($request,$nextFileName,$destinationPath); 
      }
      

      // for same as address
      if(isset($request->same_as_address1) && $request->same_as_address1==1){
         $data->street2 = $request->street;
         $data->country_id2 = $request->country_id;
         $data->city2 = $request->city;
         $data->state2 = $request->state;
         $data->post_code2 = $request->post_code;
      }
      */

      if ($data->save()) {        
        return redirect('/member/new')->with('massage','Information Saved Successfully. Ref ID: '.$data->id);
      }else return back()->with('error','Information not save....')->withInput();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\Members  $Members
     * @return \Illuminate\Http\Response
     */
    public function show(Members $Members)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\Members  $Members
     * @return \Illuminate\Http\Response
     */
    public function edit(Members $Members, $id)
    {
        $data =   Members::findOrFail($id);
        return view('members.EditMember',compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\Members  $Members
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, Members $Members, $id)
    {
        // if ($request->tab=='info') 
        {   
            $validator = Validator::make($request->all(), [
              'name' => 'required|min:1',
            //   'mobile' => 'required|unique:members',
            //   'email' => 'required|min:1',
            //   'ssc_batch' => 'required|min:1',
            //   'hsc_batch' => 'required|min:1',
              'mobile'=>"required|unique:members,mobile, $id",
              ]);
              if ($validator->fails()) {
              return back()->withErrors($validator)->withInput();
              }
              
            $data =  Members::findOrFail($id);
            $data->fill($request->all());
             if($request->by>0){
                $data->birth_date = $request->by.'-'.$request->bm.'-'.$request->bd;
              }else unset($data->birth_date); // = '0000-00-00';
            /*
            $request->filename=$request->file('photo_path');
            //Move Uploaded File
            if(!is_null($request->filename)){
              // before new file store delete old file form dir
              $oldFile = $data->photo_path;

              if(is_null($oldFile)){
                unlink(public_path($oldFile));
              }
               // if (\File::exists(public_path($oldFile))) \File::deleteDirectory(public_path($oldFile));

              $nextFileName = 'ven_p_'.time().'i'.$id;
              $destinationPath = '/uploads/Members/Photo/'.date('Y').'/'.date('m').'';
              $uploadres =   $this->fileUpload($request,$nextFileName,$destinationPath); 
              $data->photo_path = $destinationPath.'/'.$uploadres['imagename'];
            }
            */
            // for same as address
            $data->updated_by = $request->user()->id;
            unset($data->reg_ip);
            // return $data;
            $saved = $data->save();
        }

        if (isset($request->url)) {
          return redirect($request->url)->with('massage','Information updated Succesfully');
        }
        return redirect('/Members/index/')->with('massage','Information updated Succesfully');

    }



    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\Members  $Members
     * @return \Illuminate\Http\Response
     */
    public function destroy(Members $Members)
    {
        //
    }


    public function fileUpload(Request $request,$fname='',$path='',$fsize=1024)
    { if(empty($fname)) $fname=time();
       
        // $image = $request->file('photo_path');
        $image = $request->filename;
        $input['imagename'] = $fname.'.'.$image->getClientOriginalExtension();
        if (empty($path)) {
          $destinationPath = public_path('./uploads/'.date('Y').'/'.date('m').'');
          
        }else $destinationPath = public_path($path);
        
        $input['destinationPath'] = $destinationPath;
        $image->move($destinationPath, $input['imagename']);
        
        return $input;
        return back()->with('success','File Upload successful');
    }




}
