<?php

// namespace App\Http\Controllers;
namespace App\Http\Controllers\Members;
use App\Http\Controllers\Controller;

use App\Models\AlumniRegistration;
use Illuminate\Http\Request;

use Illuminate\Support\Facades\File;

use Illuminate\Support\Facades\Storage;
use Validator;

class AlumniRegistrationController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
      // dd($request->all()); 
      $validator = Validator::make($request->all(), [
      'name' => 'required|min:1',
      'mobile' => 'required|unique:alumni_registrations',
    //   'email' => 'required|min:1',
    //   'ssc_batch' => 'required|min:1',
    //   'hsc_batch' => 'required|min:1',
      ]);
      if ($validator->fails()) {
      return redirect('/')->withErrors($validator)->withInput();
      }
      $per_person_fee = 1000;
      $data = new AlumniRegistration;
      $adult_member = $request->member_adult == 0 ? 1 : $request->member_adult + 1;
      
      $data->fill($request->all());
      $data->created_by = 1111;//$request->user()->id;
      $data->updated_by = 1111;//$request->user()->id;
      $data->member_date = date('Y-m-d');
      $data->reg_ip = \Request::ip();
      $data->total_fee = $adult_member * $per_person_fee;
      $data->member_adult = $adult_member;
      // dd($data->member_adult);

      if($request->hasFile('photo'))
      {
          $cp = $request->file('photo');
          $extension = strtolower($cp->getClientOriginalExtension());
          $randomFileName = 'file'.date('Y_m_d_his').'_'.rand(10000000,99999999).'.'.$extension;

          Storage::disk('public')->put('alumniAvatar/'.$randomFileName, File::get($cp));

          $data->photo = $randomFileName;
          $data->save();
      } 

      if($request->by>0){
        $data->birth_date = $request->by.'-'.$request->bm.'-'.$request->bd;
      }else  unset($data->birth_date);// $data->birth_date = '0000-00-00';
    //  return  $data;


      if ($data->save()) {      
          
          // email send 
            $to = "secretary@mssalumni.org, $data->email";
        $subject = "Registration Confirmation - ".$data->id;

$message = "
<html>
<head>
<title>Registration Confirmation </title>
</head>
<body>
<p>

Greetings <b>".$data->name."</b>, <br>
Thank you for completing your registration. Please 'make payment' in below mentioned payment instructions to confirm your registration.<br> 

Reference ID:  ".$data->id." <br> 
Adults (5 years + ): ".$adult_member."  <br> 
Kids (below 5 years): ".$data->member_chield."  <br> 
Total Participant: ".($adult_member+$data->member_chield)."  <br> 
Total Fee: ".($data->total_fee)."  <br>
<span style='background: #daf206;'> 
<br><b><u>Payment Instructions</u></b> : <br>
-> If you want to pay using MFS please pay to 01712270421 bKash(Agent)/Rocket/Nagad/Upay.
<br>
-> If you want to pay using bank deposit please pay to 
Name of Beneficiary : Madhupur Shahid Smrity Alumni Association
Name of Bank : NCC Bank
Address : Madhupur Branch, Tangail
Account No. : 00640310028845.
</span>
<br> 
<br> 
For further help, please contact +88 01717055765 (Abir Mahamud). <br>

This email confirms that your information is submitted and recorded in the registration database. Remember your 'Reference ID' for any registration-related communication.  <br> <br> <br> 


Regards, <br>
Re-union Registration Team <br>
Alumni Office <br>
Madhupur Shahid Smrity College Building, 3rd Floor. <br>
1996, Madhupur Upazila, Tangail District, Dhaka Division, Bangladesh. <br>
Helpline: +88 01717055765 <br>
Email: secretary@mssalumni.org <br>
Connect with us: https://mssalumni.org/ <br>
</p>

  

</body>
</html>
";


          // Always set content-type when sending HTML email
          $headers = "MIME-Version: 1.0" . "\r\n";
          $headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";

          // More headers
          $headers .= 'From: <noreplay@mssalumni.org>' . "\r\n";
         // $headers .= 'Bcc: atiktechidea@gmail.com' . "\r\n";
         // $headers .= 'Cc: '.$data->email.'' . "\r\n";
          
          mail($to,$subject,$message,$headers);
          // end email send 
          
          // send sms
   /*
   Information is saved.
Please make payment to confirm your registration.
ID:".$data->id.'
Adults:'.$adult_member.',Kids:'.intval($data->member_chield).',
Fees:Tk '.$data->total_fee.
'bKash(Agent)/Rocket/Nagad/Upay-01712270421
*/       
          $url = "http://66.45.237.70/api.php";
$number=$data->mobile; if(empty($number) || strlen($number)<10) $number = "8801717055765";
$text="#MSSAA

Information saved.
Plz make payment to confirm the registration. 

ID# ".$data->id."
Adult# ".$adult_member.",Kid# ".intval($data->member_chield).",
Fee:Tk ".$data->total_fee."

bKash/Rocket/Nagad/Upay-01712270421 (Agent).";

$data01= array(
'username'=>"01717055765",
'password'=>"3WFDNV2C",
'number'=>"$number",
'message'=>"$text"
);

$ch = curl_init(); // Initialize cURL
curl_setopt($ch, CURLOPT_URL,$url);
curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query($data01));
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
$smsresult = curl_exec($ch);
$p = explode("|",$smsresult);
$sendstatus = $p[0];

          //end sms
          
        return redirect('/?ref='.$data->id.'&msg=success&2022042300021')->with('massage','Information Saved Successfully. Ref ID: '.$data->id.'. Total Fee: '.$data->total_fee.'.');
      }else return back()->with('error','Information not save....')->withInput();
    }

    /**
     * Display the specified resource.
     *
     * @param  \App\Models\AlumniRegistration  $alumniRegistration
     * @return \Illuminate\Http\Response
     */
    public function show(AlumniRegistration $alumniRegistration)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  \App\Models\AlumniRegistration  $alumniRegistration
     * @return \Illuminate\Http\Response
     */
    public function edit(AlumniRegistration $alumniRegistration)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \App\Models\AlumniRegistration  $alumniRegistration
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, AlumniRegistration $alumniRegistration)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  \App\Models\AlumniRegistration  $alumniRegistration
     * @return \Illuminate\Http\Response
     */
    public function destroy(AlumniRegistration $alumniRegistration)
    {
        //
    }
}
